#include <vcl.h>
#pragma hdrstop

#include "MainU.h"
//---------------------------------------------------------------------------
#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void TForm1::SetCheck(
  const TRect &Rect, bool IsChecked)
{
  // Code to create checked
  // or unchecked mark
  DBGrid1->Canvas->FillRect(Rect);
  int SquareSize = 13;
  // Location of check mark
  int NewTop = NewDimensions(
    Rect.Top, Rect.Bottom, SquareSize);
  int NewLeft = NewDimensions(
    Rect.Left, Rect.Right, SquareSize);
  TRect ARect;
  ARect.Left = NewLeft;
  ARect.Top = NewTop;
  ARect.Right = NewLeft + SquareSize;
  ARect.Bottom = NewTop + SquareSize;
  UINT tmpState = DFCS_BUTTONCHECK |
    (IsChecked == true) ? DFCS_CHECKED : 0;
  DrawFrameControl(DBGrid1->Canvas->Handle,
    (RECT*)&ARect, DFC_BUTTON, tmpState);
}

TWinControl* TForm1::FindGridControl(
  AnsiString FieldName, bool IsVisible)
{
  TWinControl *tmpWC = NULL;
  TWinControl *tmpWCDBControl[] = {DBCheckBoxGrid,
    /*FirstDBControl, SecondDBControl,*/ NULL};
  AnsiString tmpWCFieldName[3];

  tmpWCFieldName[0] = DBCheckBoxGrid->DataField;
// tmpWCFieldName[1] = FirstDBControl->DataField;
// tmpWCFieldName[2] = SecondDBControl->DataField;

  int n = 0;
  while (tmpWCDBControl[n] != NULL)
  {
    if (FieldName == tmpWCFieldName[n])
    {
      tmpWC = tmpWCDBControl[n];
      tmpWC->Visible = IsVisible;
      if (tmpWC->Parent != DBGrid1->Parent)
        tmpWC->Parent = DBGrid1->Parent;
      break;
    }
  ++n;
  }
  return tmpWC;
}

int TForm1::NewDimensions(
  int Rect1, int Rect2, int Dimension)
{
  int NewDm = Rect2 - Rect1 - Dimension;
  NewDm = Rect1 + ((NewDm > 0) ? NewDm / 2 : 0);
  return NewDm;
}

void __fastcall TForm1::DBGrid1DrawColumnCell(
  TObject *Sender, const TRect &Rect, int DataCol,
  TColumn *Column, TGridDrawState State)
{
  if (State.Contains(gdFocused) ||
      State.Contains(gdSelected))
  {
    TWinControl *tmpWC =
      FindGridControl(Column->FieldName, true);
    if (tmpWC != NULL)
    {
      if (tmpWC == DBCheckBoxGrid)
      {
        int BorderMargin =
          DBGrid1->BorderStyle == bsSingle ? 2 : 0;

          DBGrid1->Canvas->FillRect(Rect);
          //in case it is reused for multiple fields
          DBCheckBoxGrid->DataField =
            Column->FieldName;
          int NewLeft = NewDimensions(Rect.Left,
            Rect.Right, DBCheckBoxGrid->Width);
          tmpWC->Left = NewLeft +
            DBGrid1->Left + BorderMargin;
          int NewTop = NewDimensions(Rect.Top,
            Rect.Bottom, DBCheckBoxGrid->Height);
          tmpWC->Top = NewTop +
            DBGrid1->Top + BorderMargin;
      }
      else
      {
        int LineMargin = 1;
        tmpWC->Left = Rect.Left + LineMargin;
        tmpWC->Width =
          Rect.Right - Rect.Left - LineMargin;
        tmpWC->Top =
          Rect.Top + LineMargin + DBGrid1->Top;
        tmpWC->Height =
          Rect.Bottom - Rect.Top - LineMargin;
      }
    }
  }
  else
  {
    if (FindGridControl(Column->FieldName,
          false) == DBCheckBoxGrid)
    {
      bool IsChecked = Table1->FieldByName(
        Column->FieldName)->AsBoolean;
      SetCheck(Rect, IsChecked);
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DBGrid1ColExit(
  TObject *Sender)
{
  FindGridControl(
    DBGrid1->SelectedField->FieldName, false);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DBGrid1KeyPress(
  TObject *Sender, char &Key)
{
  TWinControl *tmpWC = FindGridControl(
    DBGrid1->SelectedField->FieldName, true);
  if (tmpWC != NULL)
  {
    DBGrid1->Repaint();
    tmpWC->SetFocus();
    SendMessage(tmpWC->Handle, WM_CHAR, Key, 0);
  }
}
//---------------------------------------------------------------------------
